;;; - ------------------------------------------------------------------------------- - ;
;;; -                T O O L - A C M - L A Y O U T S E T U P                          - ;
;;; - ------------------------------------------------------------------------------- - ;
;;; - Beschreibung : Gibt Informationen ber angeklicktes Polyliniensegment zurck    - ;
;;; - Befehle      : LAYOUTSETUP  PAGESETUPS-DELALL                                   - ;
;;; - ------------------------------------------------------------------------------- - ;
;;; - letzte nderung am : 15.02.2024                                                 - ;
;;; -              durch : Thomas Krger                                              - ;
;;; - ------------------------------------------------------------------------------- - ;
(vl-load-com)
(defun C:LAYOUTSETUP(/ LAYOUTLISTE PSETUPLISTE FLAGS
                       DT:LAYOUT-LIST DT:PAGESETUP-LIST WRITE-DCL LISTBOX:CHECK
                       DLG-CHECK DT:PAGESETUPIMPORT DLG-RUN DT:GET-BASE-DOCUMENTOBJECT
                    )   
  (defun DT:LAYOUT-LIST(DOC / LAYOUTS)
    (or(and(=(type DOC)'VLA-OBJECT)
           (vlax-property-available-p DOC 'ModelSpace)
       )       
       (setq DOC(vla-get-activedocument(vlax-get-acad-object)))
    )    
    (vlax-for ITEM (vla-get-layouts DOC)
      (setq LAYOUTS(cons
                     (list(strcase(vla-get-name ITEM))ITEM(vla-get-taborder ITEM))
                     LAYOUTS
                   )
      )
    )
    LAYOUTS
  )
  (defun DT:PAGESETUP-LIST(DOC / PAGESETUPS )
    (or(and(=(type DOC)'VLA-OBJECT)
           (vlax-property-available-p DOC 'ModelSpace)
       )
       (setq DOC (vla-get-activedocument(vlax-get-acad-object)))
    )
    (vlax-for ITEM (vla-get-plotconfigurations DOC)
      (setq PAGESETUPS(cons
                        (list(strcase (vla-get-name ITEM))ITEM)
                        PAGESETUPS
                      )
      )
    )
    PAGESETUPS
  )
  (defun DT:GET-BASE-DOCUMENTOBJECT(FILENAME WRITEPROTECTED? / DOCLIST DOC TEMPNAME)    
    (vlax-for ITEM (vla-get-documents(vlax-get-acad-object))
      (setq DOCLIST(cons(list (strcase(vla-get-fullname ITEM)) ITEM) DOCLIST))
    )
    (setq DOC
      (cond
        ((not FILENAME)(vla-get-activedocument(vlax-get-acad-object)))      
        ((and(=(type FILENAME)'STR)(setq FILENAME(strcase FILENAME))(cadr(assoc FILENAME DOCLIST)))
          (cadr(assoc FILENAME DOCLIST))
        )               
        ((and(setq FILENAME(findfile FILENAME))
             (or(not(vl-catch-all-error-p
                       (setq DOC (vl-catch-all-apply
                                   'vla-GetInterfaceObject
                                   (list
                                     (vlax-get-acad-object)
                                     (strcat "ObjectDBX.AxDbDocument."(substr(getvar"ACADVER")1 2))
                                   )  
                                 )
                       )
                    )
                )             
                (not(vl-catch-all-error-p
                      (setq DOC (vl-catch-all-apply
                                  'vla-GetInterfaceObject
                                  (list (vlax-get-acad-object) "ObjectDBX.AxDbDocument")
                                )
                      )
                    )
                )
             )  
         )
           (cond
             ((not(vl-catch-all-error-p     
                    (vl-catch-all-apply 
                      'vla-open
                      (list DOC FILENAME (if WRITEPROTECTED? :vlax-true :vlax-false))
                    )                  
                  )  
              )
                DOC
             )
             ((and(setq TEMPNAME(vl-filename-mktemp "TEMP.dwg"))
                  (or(not(setq TEMPNAME(findfile TEMPNAME)))
                     (vl-file-delete TEMPFILE)
                  )      
                  (vl-file-copy FILENAME TEMPNAME)                        
                  (not(vl-catch-all-error-p     
                        (vl-catch-all-apply 
                          'vla-open
                          (list DOC TEMPNAME (if WRITEPROTECTED? :vlax-true :vlax-false))
                        )                  
                      )  
                  )
              )
                DOC
             ) 
             ('T
              (not(vl-catch-all-error-p(vl-catch-all-apply 'vlax-release-object(list DOC))))
              (setq DOC nil)
             )
           )
        ) 
      )
    )
  )

  (defun LAYOUTSETUPDLG(/ WRITE-DCL LISTBOX:CHECK DT:PAGESETUPIMPORTDLG
                          DLG-CHECK DLG-RUN DIR
                       )
    (defun WRITE-DCL(/ DIR FILE)
      (if(and(setq DIR(vl-filename-mktemp "LAYOUTSETUP.DCL"))
             (setq FILE (open DIR "w"))
         )   
        (progn
          (mapcar
             '(lambda (X)(princ (strcat X "\n") FILE))  
            '(             
              "LAYOUTSETUP"
              ": dialog"            
              "   { key = DLGTITEL;"
              "     : row"
              "     {"
              "       : boxed_column"
              "       {"            
              "         : text"
              "         { label       = \"Seiteneinrichtungen\";"
              "           key         = \"PS-LISTTXT\";"
              "           width       = 40;"
              "           fixed_width = true;"                        
              "           alignment = left;"
              "         }"
              "         : list_box"
              "         { key         = \"PS-LIST\";"
              "           width       = 40;"
              "           fixed_width = true;"
              "           height      = 10;"
              "           fixed_height= true;"
              "           multiple_select = false;"
              "           alignment = left;"
              "         }"
              "         : button"
              "         { label = \"Importieren\";"
              "           key = \"IMPORT\";"
              "           fixed_width = true;"
              "           width = 40;"
              "           alignment = centered;"
              "           mnemonic =\"I\";"
              "         }"                               
              "       }"
              "       : boxed_column"
              "       {"            
              "         : text"
              "         { label       = \"Layouts\";"
              "           key         = \"LT-LISTTXT\";"
              "           width       = 40;"
              "           fixed_width = true;"                        
              "           alignment = left;"
              "         }"
              "         : list_box"
              "         { key         = \"LT-LIST\";"
              "           width       = 40;"
              "           fixed_width = true;"
              "           height      = 10;"
              "           fixed_height= true;"
              "           multiple_select = true;"
              "           alignment = left;"
              "         }"
              "         : button"
              "         { label = \"Alle\";"
              "           key = \"SELECT\";"
              "           fixed_width = true;"
              "           width = 40;"
              "           alignment = centered;"
              "           mnemonic =\"A\";"
              "         }"                               
              "       }"            
              "     }"            
              "     : row"
              "     {"        
              "       : button"
              "       { label=\"Anwenden\";"
              "         key=\"OK\";"
              "         fixed_width=true;"
              "         width=12;"
              "         alignment=centered;"            
              "         is_default = true;"
              "       }"
              "       : button"
              "       { label=\"Ende\";"
              "         key=\"END\";"
              "         fixed_width=true;"
              "         width=12;"
              "         alignment=centered;"
              "       }"
              "       : cancel_button"
              "       { label = \"Abbruch\";"
              "         key = \"CANCEL\";"
              "         fixed_width = true;"
              "         width = 12;"
              "         alignment = centered;"
              "         is_cancel = true;"
              "       }"
              "       : button"
              "       { label = \"Info\";"
              "         key = \"INFO\";"
              "         fixed_width = true;"
              "         width = 12;"
              "         alignment = centered;"
              "       }"
              "     }"
              "   }"

              "PAGESETUPIMPORT"
              ": dialog"
              "{  key = DLGTITEL;"
              "   : row"
              "   {"
              "     : boxed_column"
              "     {"
              "       : list_box"
              "       { label       = \"gefundene Seiteneinrichtungen:\";"
              "         key         = \"PSI-LIST\";"
              "         width       = 47;"
              "         fixed_width = true;"
              "         height      = 10;"
              "         fixed_height= true;"
              "         multiple_select = true;"
              "         alignment = left;"
              "       }"
              "       : column"
              "       { height=5;"
              "         fixed_height=true;"
              "         : row"
              "         {"
              "           : button"
              "           { label = \"Alle auswhlen\";"
              "             key = \"PSI-ALL\";"
              "             fixed_width = true;"
              "             width = 22;"
              "             alignment = left;"
              "           }"
              "           : button"
              "           { label = \"Alle abwhlen\";"
              "             key = \"PSI-NO\";"
              "             fixed_width = true;"
              "             width = 22;"
              "             alignment = left;"
              "           }"
              "         }"
              "         : toggle"
              "         { label = \"Vorhandene berschreiben\";"
              "           key   = \"OVERWRITE\";"
              "           alignment = right;"
              "         }"
              "       }" 
              "     }"
              "   }"
              "   : row"
              "   {"
              "     : button"
              "     { label = \"OK\";"
              "       key   = \"OK\";"
              "       width = 15;"
              "       fixed_width = true;"
              "       alignment = right;"            
              "     }"
              "     : cancel_button"
              "     { label = \"Abbruch\";"
              "       key = \"CANCEL\";"
              "       width = 15;"
              "       fixed_width = true;"
              "       alignment = right;"            
              "       is_cancel = true;"
              "     }"     
              "     : button"
              "     { label = \"Info\";"
              "       key   = \"INFO\";"
              "       width = 15;"
              "       fixed_width = true;"
              "       alignment = right;"            
              "     }"
              "   }"
              "}"         
             )  
          )
          (close FILE)
          DIR
        )
      )  
    )
    (defun LISTBOX:CHECK(SELECTED BASISLIST / INDEXLIST  POS)
      (if(and(=(type SELECTED)'STR)(=(type BASISLIST)'LIST))    
        (progn      
          (while (setq POS(vl-string-search " " SELECTED))
            (setq INDEXLIST  (cons (substr SELECTED 1 POS) INDEXLIST)
                  SELECTED (substr SELECTED (+ POS 2))                
            )
          )      
          (if(and(setq INDEXLIST
                   (vl-remove-if-not '(lambda(Z / Y)
                                        (and(setq Y(atoi Z))(= Y (distof Z 2))
                                            (<= 0 Y)(< Y (length BASISLIST))
                                        )
                                      )  
                                      (reverse(cons SELECTED INDEXLIST))
                   )
                 )
                 (setq SELECTED(mapcar'(lambda(Y)(nth Y BASISLIST))(mapcar 'atoi INDEXLIST)))
             )                       
            SELECTED          
          )  
        )
      )    
    )    
    (defun DT:PAGESETUPIMPORT(DIR / DLGINDEX IMPORTFILE PSILIST PSI:LIST
                                   PSI-LIST:ACTION PSI:SSET PSIMPORTS
                             )
      (defun PSI-LIST:ACTION()
        (setq PSI:SSET(LISTBOX:CHECK (get_tile "PSI-LIST") PSI:LIST))     
        (if(and(>(length PSI:LIST)0)(>(length PSI:LIST)(length PSI:SSET)))                 
          (mode_tile "PSI-ALL" 0)(mode_tile "PSI-ALL" 1)
        )
        (if(>(length PSI:SSET)0)(mode_tile "PSI-NO" 0)(mode_tile "PSI-NO" 1))
      )
      (if(and(setq IMPORTFILE(getfiled "PAGESETUPIMPORT" "" "DWG;DWT" 8))
             (setq IMPORTFILE(DT:GET-BASE-DOCUMENTOBJECT IMPORTFILE nil))
             (/=(vla-get-activedocument(vlax-get-acad-object))IMPORTFILE)
             (or(setq PSILIST(DT:PAGESETUP-LIST IMPORTFILE))
                (alert "Gewhlte Zeichnung enthhlt keine benannten Seiteneinrichtungen!")
             )
             (setq PSI:LIST(mapcar 'car(vl-sort PSILIST '(lambda(X1 X2)(<(car X1)(car X2))))))
         )                      
        (if(>(setq DLGINDEX (load_dialog DIR))0)
          (if(new_dialog "PAGESETUPIMPORT" DLGINDEX)
            (progn            
              (set_tile    "DLGTITEL" "PAGESETUPIMPORT")
              (start_list  "PSI-LIST" 3)(mapcar 'add_list  PSI:LIST)(end_list)
              (set_tile    "OVERWRITE" "1")
              (action_tile "PSI-LIST" "(PSI-LIST:ACTION)")
              (action_tile "PSI-ALL"   (strcat"(setq INDEX -1)"                                            
                                              "(repeat (length PSI:LIST)"
                                              " (set_tile \"PSI-LIST\" (itoa(setq INDEX (1+ INDEX))))"                                            
                                              ")"
                                              "(PSI-LIST:ACTION)"
                                       )
              )
              (action_tile "PSI-NO"    (strcat"(set_tile \"PSI-LIST\" \"\")"
                                              "(PSI-LIST:ACTION)"
                                       )
              )
              (action_tile "OK"        (strcat  "(setq PSIMPORTS"
                                                "  (list (LISTBOX:CHECK (get_tile \"PSI-LIST\") PSI:LIST)"
                                                "        (get_tile \"OVERWRITE\")"
                                                "  )"
                                                ")"  
                                                "(done_dialog 1)"
                                       )  
              )
              (action_tile "CANCEL"        "(setq PSIMPORTS nil)(done_dialog 0)")
              (action_tile "INFO"          "(alert(strcat \"====  PAGESETUPIMPORT ====\n\"
                                                          \" Th.Krger (tk@cad-od.de)\n\"
                                                  )
                                            )"
              )
              (start_dialog)
              (unload_dialog DLGINDEX)
              (setq PSIMPORTS
                (vl-remove-if 'null
                  (mapcar
                    '(lambda(X / OLDPS PS)
                       (if(and(setq PS (cadr(assoc X PSILIST)))
                              (or(not(setq OLDPS(assoc X PSETUPLISTE)))
                                 (and(=(cadr PSIMPORTS)"1")
                                     (not(vl-catch-all-error-p
                                           (vl-catch-all-apply
                                             'vla-delete(list (cadr OLDPS))
                                           )
                                         )
                                     )    
                                 )
                              )
                              (not(vl-catch-all-error-p
                                    (vl-catch-all-apply
                                      'vla-CopyObjects
                                      (list IMPORTFILE
                                            (vlax-make-variant
                                              (vlax-safearray-fill
                                                (vlax-make-safearray vlax-vbObject '(0 . 0)) 
                                                (list PS)
                                              )
                                            )
                                            (vlax-make-variant
                                              (vla-get-plotconfigurations
                                                (vla-get-activedocument(vlax-get-acad-object))
                                              )
                                            )  
                                      )
                                    )
                                  )
                              )
                          )
                         X
                       )  
                     )  
                    (car PSIMPORTS)
                  )  
                )  
              )       
            )
            (alert "Dialog nicht gefunden") 
          )
          (alert "Dialog nicht gefunden")       
        )
      )
      PSIMPORTS
    )

    
    (defun DLG-CHECK(FLAGS / PS PS:NAME)               
      (if(assoc (setq PS:NAME(nth(atoi (get_tile "PS-LIST"))PS:LIST))PSETUPLISTE)      
        (foreach LT (LISTBOX:CHECK (get_tile "LT-LIST") LT:LIST)
          (if(setq PS(assoc LT FLAGS))
            (setq FLAGS(subst (list LT PS:NAME) PS FLAGS))
            (setq FLAGS(append FLAGS (list(list LT PS:NAME))))
          )  
        )
      )
      FLAGS
    )  
    (defun DLG-RUN(DIR / DLGINDEX EXIT? FLAGS LT:LIST PS:LIST)    
      (setq LT:LIST(mapcar
                     'car
                     (vl-sort LAYOUTLISTE '(lambda(X1 X2)(<(caddr X1)(caddr X2))))
                   )
      )
      (setq PS:LIST(mapcar
                     'car
                     (vl-sort PSETUPLISTE '(lambda(X1 X2)(<(car X1)(car X2))))
                   )
      )          
      (while (not EXIT?)
        (if(>(setq DLGINDEX (load_dialog DIR))0)
          (if(new_dialog "LAYOUTSETUP" DLGINDEX)
            (progn            
              (set_tile    "DLGTITEL" "LAYOUTSETUP Th.Krger")          
              (start_list  "LT-LIST" 3)(mapcar 'add_list  LT:LIST)(end_list)
              (start_list  "PS-LIST" 3)(mapcar 'add_list  PS:LIST)(end_list)
              (set_tile "LT-LIST" (if(setq NR(vl-position
                                               (strcase
                                                 (vla-get-name
                                                   (vla-get-activelayout
                                                     (vla-get-activedocument(vlax-get-acad-object))
                                                   )
                                                 )
                                               )
                                               LT:LIST
                                             )
                                     )
                                    (itoa NR)
                                    "0"
                                  )      
              )
              (set_tile "PS-LIST" "0")            
              (action_tile "SELECT"  (strcat"(setq INDEX -1)"                                          
                                            "(repeat (length LT:LIST)"
                                            " (set_tile \"LT-LIST\" (itoa(setq INDEX (1+ INDEX))))"                
                                            ")" 
                                     )
              )
              (action_tile "IMPORT" (strcat "(if(DT:PAGESETUPIMPORT DIR)"
                                            "  (progn"
                                            "    (setq PSETUPLISTE(DT:PAGESETUP-LIST nil))"
                                            "    (setq PS:LIST"
                                            "      (mapcar"
                                            "       'car"
                                            "       (vl-sort PSETUPLISTE '(lambda(X1 X2)(<(car X1)(car X2))))"
                                            "      )"
                                            "    )"
                                            "    (start_list  \"PS-LIST\" 3)"
                                            "    (mapcar 'add_list  PS:LIST)"
                                            "    (end_list)"
                                            "  )"
                                            ")"  
                                    )          
              )  
              
              (action_tile "OK"            "(if(setq FLAGS (DLG-CHECK FLAGS))(done_dialog 3))")
              (action_tile "END"           "(done_dialog 1)")
              (action_tile "CANCEL"        "(setq FLAGS nil)(done_dialog 0)")
              (action_tile "INFO"          "(alert(strcat \"======  LAYOUTSETUP  ========\n\"
                                                          \" Th.Krger (tk@cad-od.de)\n\"
                                                  )
                                            )"      
              )            
              (setq EXIT?(/=(start_dialog)3))
              (unload_dialog DLGINDEX)
            )
            (progn (alert "Dialog nicht gefunden") (setq EXIT 'T))
          )
          (progn (alert "Dialog nicht gefunden") (setq EXIT 'T)) 
        )
      )
      FLAGS
    )
    (setq LAYOUTLISTE(vl-remove-if '(lambda(X)(="MODEL"(Car X)))(DT:LAYOUT-LIST nil)))  
    (setq PSETUPLISTE(DT:PAGESETUP-LIST nil))
    (setq DIR(WRITE-DCL))         
    (setq FLAGS(DLG-RUN DIR))
  )
  (if(setq FLAGS(LAYOUTSETUPDLG))
    (progn
      (foreach FLAG FLAGS
        (not(vl-catch-all-error-p
              (vl-catch-all-apply                        
                'vla-copyfrom
                (list
                  (cadr(assoc (car  FLAG) LAYOUTLISTE))
                  (cadr(assoc (cadr FLAG) PSETUPLISTE))
                )
              )
            )
        )                                          
      )
      (vla-regen(vla-get-activedocument(vlax-get-acad-object))acAllViewports)
    )
  )
  (princ)
)

  
(defun C:PAGESETUPS-DELALL(/ ITEM)
  (vlax-for ITEM (vla-get-plotconfigurations
                   (vla-get-activedocument(vlax-get-acad-object))
                 )
     (vl-catch-all-error-p(vl-catch-all-apply'vla-delete (list ITEM)))   
  )
)
;;; - ------------------------------------------------------------------------------- - ;
(defun ACM-LAYOUTSETUP:INFO() 
  (mapcar
    'princ
    (list
      "\n\n"
      "\nLAYOUTSETUP : Einrichten von LAYOUTS" 
      "\n=========== "
      "\n(C) Thomas Krger 2024" 
      "\nE-Mail: tk@cad-od.de"
      "\nBefehlszeilenaufruf : LAYOUTSETUP / PAGESETUPS-DELALL\n"   
    )
  )
  (princ)  
)
;;; - ------------------------------------------------------------------------------- - ;
(ACM-LAYOUTSETUP:INFO)
(princ)
